<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Models\AboutCategory;
use App\Http\Controllers\Controller;
use App\Http\Requests\About\StoreAboutCategoryRequest;
use App\Http\Requests\About\UpdateAboutCategoryRequest;

class AboutCategoryController extends Controller
{

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.about_categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAboutCategoryRequest $request)
    {
           AboutCategory::create($request->requestHandler());
           return redirect()->route('abouts.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $about = AboutCategory::find($id);
        return view('Admin.about_categories.show',compact('about'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $about = AboutCategory::find($id);
        return view('Admin.about_categories.edit',compact('about'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAboutCategoryRequest $request, $id)
    {

           $AboutCategory = AboutCategory::findOrFail($id);
           $AboutCategory->update($request->requestHandler());
            return redirect()->route('abouts.index')->with('message',
            show_success());


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $AboutCategory = AboutCategory::find($id);


        if($AboutCategory->image){
            delete_file($AboutCategory->image);
        }
        if($AboutCategory->delete()){
            return redirect()->route('abouts.index')->with('message',show_success());
        }
    }

}