<?php

namespace App\Http\Controllers\admin;

use App\Models\About;
use Illuminate\Http\Request;
use App\Models\AboutCategory;
use App\Http\Controllers\Controller;
use App\Http\Requests\About\StoreAboutRequest;
use App\Http\Requests\About\UpdateAboutRequest;


class AboutController extends Controller
{
    public function index(Request $request)
    {
        $abouts = About::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        $about_categories = AboutCategory::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        return view('Admin.about.index',compact('abouts','about_categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('Admin.about.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAboutRequest $request)
    {


        About::create($request->requestHandler());
        return redirect()->route('abouts.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(About $about)
    {
        return view('Admin.about.show',compact('about'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(About $about)
    {
        return view('Admin.about.edit',compact('about'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAboutRequest $request, $id)
    {
        $about = About::findOrFail($id);

        $about->update($request->requestHandler());

         return redirect()->route('abouts.index')->with('message',
            show_success());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(about $about)
    {
        if($about->image){
          delete_file($about->image);
        }

        if($about->delete()){
            return redirect()->route('abouts.index')->with('message',show_success());
        }
    }


}