<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Activity;
use Exception;
use Illuminate\Http\Request;

class ActivityController extends Controller
{
    public function index(Request $request)
    {

        $activities = Activity::get();

         return view('Admin.activities.index',compact('activities',));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('Admin.activities.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


               $request->validate([
                'url'=>'required',
                'description'=>'required',
                'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
              ]);


           // image store
           if($request->hasFile('image')){
             $imageName = time().'.'.$request->image->extension();

             $imagePath = $request->image->move('images/activities/',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);
            //  $imagePath = $request->file('image')->storeAs('images/activities',$imageName,'image');
             $data['image']=$request->$imagePath;
           }else{
            $imagePath = null;
           }

           activity::create([
            'url'=>$request->url,
            'description'=>$request->description,
            'image'=>$imagePath
           ]);


           return redirect()->route('activities.index')->with('message',show_success());
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(activity $activity)
    {
        return view('Admin.activities.edit',compact('activity'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

           $activity = Activity::findOrFail($id);

           $request->validate([
            'url'=>'required',
            'description'=>'required',

            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
           ]);

           // image update
          if($request->hasFile('image')){
            if($activity->image){
                unlink($activity['image']);
            }

             $imageName = time().'.'.$request->image->extension();
             $imagePath = $request->image->move('images/activities',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);
          }else{
             $request->validate([
           ]);
           $imagePath = $activity->image;
       }

        // upate
        $activity->url=$request->input('url');
        $activity->description = $request->input('description');
        $activity->image = $imagePath;

        if($activity->save()){
            return redirect()->route('activities.index')->with('message',
            show_success());
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Activity $activity)
    {
        if($activity->image){
           try{
            unlink($activity->image);
             $message = show_success();
           }catch(Exception $e){

            $message = $e->getMessage();

           }
        }
        if($activity->delete()){
            return redirect()->route('activities.index')->with('message',$message);
        }
    }

}