<?php

namespace App\Http\Controllers\admin;

use App\Models\Donar;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;

class DonarLogoController extends Controller
{
    public function index(Request $request)
    {

        $donars = Donar::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.donar.index',compact('donars'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.donar.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


       
               $request->validate([
               
                'image'=>'required|image|mimes:png,jpg,jpeg,gif'
              ]);

           // image store
           if($request->hasFile('image')){
             $imageName = time().'.'.$request->image->getClientOriginalName();
             $imagePath = $request->image->move('images/imageGallaries',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);

           Donar::create([
            'url'=>$imagePath
           ]);

           return redirect()->route('donars.index')->with('message',show_success());
       }
    }

  

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
          $donarLogo  = Donar::findOrFail($id);
        if($donarLogo->url){

            try{
                unlink(asset($donarLogo->url));
                $message = show_success();
            }catch(Exception $e){
                $message = $e->getMessage();

            }

        }

        if($donarLogo->delete()){
            return redirect()->route('donars.index')->with('message',$message);
        }
    }



}