<?php

namespace App\Http\Controllers\admin;

use App\Models\Donation;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DonationCotroller extends Controller
{
    public function index(){
        $donations  = Donation::get();

        return view('Admin.donation.index',compact('donations'));

   }

   public function store(Request $request){
        $request->validate([
            'info'=>'required',
            'status'=>'required'
        ]);

        $donation = new Donation();
        $donation->info = $request->info;
        $donation->status = $request->status;

        if($donation->save()){
            return redirect()->back()->with('message',show_success());
        }
   }


   public function update(Request $request){

    $donation = Donation::first();

    if($request->info){
     $info = $request->info;

     $request->validate([
        'info'=>'required',
        'status'=>'required'
    ]);


    }else{
        $info = $donation->info;
    }


    $donation->info = $info;
    $donation->status = $request->status;


    if($donation->save()){
        return redirect()->route('donations.index')->with('message',show_success());
    }
}

public function edit(){
    $donation  = Donation::first();

    return view('Admin.donation.edit',compact('donation'));

}


}