<?php

namespace App\Http\Controllers\Admin;

use App\Models\Job;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;

class JobController extends Controller
{
    public function index(Request $request)
    {
        if($search = $request->search){
          $jobs = Job::where('title','LIKE',"%{$search}%")->paginate(config('aictcms.pageNumber'))->withQueryString();
        }else{
          $jobs = Job::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        }
        return view('Admin.job.index',compact('jobs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('Admin.job.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

            //  dd($request->all());

          $request->validate([
           'summary'=>'required',
            'description'=>'required'
          ]
          );
          try{
            Job::create($request->all());
            return redirect()->route('jobs.index')->with('message',show_success());
          }catch(Exception $e){
            return redirect()->back()->with('message',show_error());
          }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $jobs = Job::with('applicants')->find($id);


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Job $job)
    {
        return view('Admin.job.edit',compact('job'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
           $job = Job::findOrFail($id);
           $request->validate([
            'summary'=>'required',
            'description'=>'required'
           ]);
           try{
            $job->update($request->all());
                return redirect()->route('jobs.index')->with('message',
                show_success());
             }
           catch(Exception $e){
            return redirect()->route('jobs.index')->with('message',
                show_error());
           }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Job $Job)
    {
        if($Job->delete()){
            return redirect()->route('jobs.index')->with('message',show_success());
        }
    }


  public function updateShow($id, $show){
        $Job = Job::findOrFail($id);
        $Job->show = $show;
        if($Job->save()){
            return redirect()->back()->with('message',show_success());
        }
    }


}
