<?php

namespace App\Http\Controllers\admin;

use App\Models\Menu;
use App\Models\Page;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Menu\StoreMenuRequest;
use App\Http\Requests\Menu\UpdateMenuRequest;
use Exception;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

class MenuController extends Controller
{

    public function index()
    {

        $menus = Menu::with('sub_menus')->orderBy('menu_order','ASC')->paginate(config('aictcms.pageNumber'));

        return view('Admin.menu.index',compact('menus'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {


        $menu = Menu::orderBy('menu_order','desc')->first();



        if($menu){
            $menuOrder = $menu->menu_order+1;
        }else{
            $menuOrder = 1;

        }
        // $directories =  Storage::disk('admin')->directories();

        // Enum Pages route name
        $pages = menus();
        return view('Admin.menu.create',compact('pages','menuOrder',));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreMenuRequest $request)
    {

            if($request->resource_type =='page'){
                  $page = Page::create($request->pageHandler());
                  Menu::create($request->menuHandler($page->id));
            }else{

                  Menu::create($request->menuHandler());

            }

           return redirect()->route('menus.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Menu $menu)
    {
        return view('Admin.show',compact('menu'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $menu = Menu::find($id);


               // Enum Pages route name
               $pages = menus();
        if($menu->resource_id){
        $post = Page::where('id',$menu->resource_id)->first();
        return view('Admin.menu.edit',compact('menu','post'));
        }
        return view('Admin.menu.edit',compact('menu','pages'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateMenuRequest $request, $id)
    {

           $menu = Menu::findOrFail($id);
           $menu->update($request->menuHandler());

           if($request->resource_id){
           $page = Page::findOrFail($menu->resource_id);
           $page->update($request->pageHandler());
           }
            return redirect()->route('menus.index')->with('message',
            show_success());


    }


  // Eidt menu order
  public function order(Request $request){
    foreach ($request->menu_orders as $key => $value) {
        Menu::where('id',$key)->update([
            'menu_order'=>$value
        ]);
    }

    return redirect()->route('menus.index')->with('message',show_success());
  }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Menu $menu)
    {
        if($menu->resource_id){
            $page = Page::findOrfail($menu->resource_id);
             delete_file($page->image);
            $page->delete();
        }

        if($menu->delete()){
            return redirect()->route('menus.index')->with('message',show_success());
        }
    }


}
