<?php

namespace App\Http\Controllers\admin;

use App\Models\SlideShow;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Media\StoreBannerRequest;
use App\Http\Requests\Media\UpdateBannerRequest;
use Exception;

class SlideShowController extends Controller
{
    public function index(Request $request)
    {

        $posts = SlideShow::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.slide_show.index',compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.slide_show.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBannerRequest $request)
    {

          SlideShow::create($request->requestHandler());
           return redirect()->route('slideShows.index')->with('message',show_success());
    }




    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = SlideShow::find($id);
        return view('Admin.slide_show.edit',compact('post'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBannerRequest $request, $id)
    {
           $slideShow = SlideShow::find($id);
           $slideShow->update($request->requestHandler());

            return redirect()->route('slideShows.index')->with('message',
            show_success());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
          $slideShow  = SlideShow::findOrFail($id);
        if($slideShow->image){
            delete_file($slideShow->image);

        }
        if ($slideShow->da_image) {
             delete_file($slideShow->da_image);
        }

        if ($slideShow->pa_image) {
            delete_file($slideShow->pa_image);


        }
        if($slideShow->delete()){
            return redirect()->route('slideShows.index')->with('message',show_success());
        }
    }


}
