<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Http\Requests\OrderProductRequest;
use App\Mail\OrderProductAdminMail;
use App\Mail\OrderProductUserMail;
use App\Models\Banner;
use App\Models\Order;
use App\Models\Product;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ProductController extends Controller
{


    public function index(){
        $posts = Product::get();
        return view('website.product.index',compact('posts'));
    }


      public function show($lang,$id){
        $post = Product::find($id);
        return view('website.product.show',compact('post'));
    }






    public function order(OrderProductRequest $request){

           $data = $request->all();
            $orderedProduct =Order::create($data);

            $product = Product::find($request->product_id);
            $product['total_price'] = $product->price*$request->quantity;
            $product['quantity'] = $request->quantity;
            $product['order_id']=$orderedProduct->id;



           try{
            // Mail to customer
            Mail::to($request->email)->send(new OrderProductUserMail($data,$product));
             //  Mail to admin
             Mail::to('mahdi@aryan.af')->send(new OrderProductAdminMail($data,$product));

             toast('You Hav Successfully Ordered Our Produt!','success');
             return redirect()->back();
           }catch(Exception $e){
             toast('Sorry Problem Occured!','error');
             return redirect()->back();
           }
    }


    public function water_calculate(){

        $post = Banner::where('section','Water_Calculation')->first();
        return view('website.water_calculator.index',compact('post'));
    }
}
