<?php

namespace App\Http\Requests\Media;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSocialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

       /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
              public function authorize()
    {
        return auth()->check();
    }
    public function rules()
    {
        return [
            'image'=>'nullable|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:5120 ',
            'da_image'=>'nullable|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:5120 ',
            'pa_image'=>'nullable|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:5120 ',
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();
      if($this->image){

          $allRequest['image'] = upload_file($this->image);
          delete_file($this->image);
      }else{
          $allRequest['image'] = $this->old_image;


      }

       if($this->da_image){

          $allRequest['da_image'] = upload_file($this->da_image);
          delete_file($this->da_image);


      }else{
          $allRequest['da_image'] = $this->old_da_image;
      }

        if($this->pa_image){

          $allRequest['pa_image'] = upload_file($this->pa_image);
          delete_file($this->pa_image);

      }else{
          $allRequest['pa_image'] = $this->old_pa_image;
      }

      return $allRequest;
    }

}