<?php

namespace App\Http\Requests\Menu;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }


     public function rules()
    {
        return [
            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif',
            'menu_name'=>'required',
            'da_menu_name'=>'required',
            'pa_menu_name'=>'required',
            'route_name'=>'nullable',
        ];
    }




    public function pageHandler(){
             $allRequest = $this->all();
             if($this->hasFile('image')){
                 $allRequest['image'] = upload_file($this->image);
                 delete_file($this->old_image);
             }else{
                 $allRequest['image'] = $this->old_image;
             }
           return $allRequest;
     }

   public function menuHandler(){
       $allRequest = $this->all();
       return $allRequest;
    }
}
