<?php

namespace App\Http\Requests\Menu;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSubMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

     public function authorize()
    {
        return true;
    }


     public function rules()
    {
        return [
            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif',
            'sub_menu_name'=>'required',
            'da_sub_menu_name'=>'required',
            'pa_sub_menu_name'=>'required',

        ];
    }




    public function pageHandler(){
             $allRequest = $this->all();
             if($this->hasFile('image')){
                 $allRequest['image'] = upload_file($this->image);
                 delete_file($this->old_image);
             }else{
                 $allRequest['image'] = $this->old_image;
             }
           return $allRequest;
     }

   public function menuHandler(){
       $allRequest = $this->all();
       return $allRequest;
    }
}