<?php

namespace App\Http\Requests\Post;

use Illuminate\Foundation\Http\FormRequest;

class StorePostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

        public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'title'=>'required',
            'image'=>'nullable|mimes:png,jpg,jpeg,gif,pdf'
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();

      if($this->image){
          $allRequest['image'] = upload_file($this->image);

      }
      return $allRequest;
    }
}