<?php

namespace App\Http\Requests\Post;

use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

        public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'image'=>'required|mimes:png,jpg,jpeg,gif|max:5120 ',
            // 'caption_image'=>'required|mimes:png,jpg,jpeg,gif|max:5120 ',
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();
      if ($this->hasFile('image')) {
        $allRequest['image'] = upload_file($this->image);
      }
      if ($this->hasFile('caption_image')) {
        $allRequest['caption_image'] = upload_file($this->caption_image);

      }

      return $allRequest;
    }
}