<?php

namespace App\Http\Requests\Post;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
          return [
            'image'=>'nullable|mimes:png,jpg,jpeg,gif|max:5120 ',
            // 'caption_image'=>'nullable|mimes:png,jpg,jpeg,gif|max:5120 ',
        ];

    }


    public function requestHandler(){
      $allRequest = $this->all();
      if($this->image){

          $allRequest['image'] = upload_file($this->image);
          delete_file($this->image);
      }else{
          $allRequest['image'] = $this->old_image;


      }

    //    if($this->caption_image){

    //       $allRequest['caption_image'] = upload_file($this->caption_image);
    //       delete_file($this->caption_image);


    //   }else{
    //       $allRequest['caption_image'] = $this->old_caption_image;
    //   }



      return $allRequest;
    }

}
