<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreJobRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'firstName' => 'required',
            'lastName' => 'required',
            'gender' => 'required',
            'phoneNumber' => 'required',
            'email' => 'required',
            'file' => 'required|mimes:pdf',
        ];
    }

    public function handleRequest(){
        $fileName = time().'-'.str()->slug($this->firstName).'-'.str()->slug($this->lastName).'.'.$this->file->extension();
        $path = $this->file->storeAs('CVApplyPeople', $fileName, 'upload');
        $allRequest = $this->all();
        $allRequest['file'] = $path;
        return $allRequest;
    }

}
