<?php

namespace App\Models;
use App\Models\Scopes\AdminSearchScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use HasFactory;
    protected $fillable = ['title','da_title','location','start_date','pa_title','description','image','da_description','pa_description'];

    public function scopeFilter($query){
        if($q = request('q')){
            return $query->where("title","like","%{$q}%");
        }
    }

    public static function booted(){
        static::addGlobalScope(new AdminSearchScope);
    }
}