<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\Scopes\AdminSearchScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Project extends Model
{
    use HasFactory;
    protected $fillable  = [
        'title','description','project_id','status','start_date','end_date', 'image','mission_description'
    ];

    public function scopeFilter($query){
        if($q = request('q')){
            return $query->where("title","like","%{$q}%");
        }
    }

    public static function booted(){
        static::addGlobalScope(new AdminSearchScope);
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }

}