<?php

namespace App\Models;


use App\Models\Scopes\AdminSearchScope;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Service extends Model
{
    use HasFactory;

    protected $fillable = ['title','da_title','pa_title','description','image','da_description','pa_description'];

    // public function images() {
    //     return $this->morphMany(Image::class, 'imageable');
    // }

    public static function booted(){
        static::addGlobalScope(new AdminSearchScope);
    }

    public function scopeFilter($query){
        if($q = request('q')){
            return $query->where('title','LIKE',"%{$q}%");
        }
    }

    public function scopeCustomSort($query){
        if($sort = request('sort')){
            return $query->orderBy($sort,'desc');
        }
    }

}