<?php

use App\Models\Menu;

use App\Models\WhatWe;
use App\Models\Company;
use App\Models\Service;
use App\Models\SubMenu;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Storage;

if(!function_exists('show_success')){
    function show_success(){
       $message = 'The operation was successful.';
       return $message;
    }
}

if(!function_exists('show_error')){
    function show_error(){
        $message ='The operation was not performed.';
       return $message;
    }
}



if(!function_exists('showProductImages')){

    function showProductImage($id){
         $product = Service::with('images')->find($id);

         $imageUrls = [];

         if( isset($product->images[0])){
            $imageUrls [] = $product->images[0]->url;
            $imageUrls [] = $product->images[1]->url;
         }else{
            $imageUrls[] = $product->image;
            $imageUrls[] = $product->image;
         }
         return $imageUrls;
    }
}




// return company info
if(!function_exists('w_logo')){
    function w_logo(){

        $company = Company::first();
        if($company){
            return $company->logo;
        }else{
            return null;
        }
    }
}

if(!function_exists('w_name')){
    function w_name(){

        $company = Company::first();
        if($company){
            return $company->name;
        }else{
            return null;
        }
    }
}


// return company info
if(!function_exists('company')){
    function company(){
        $company = Company::first();
        if($company){
            return $company;
        }else{
            return null;
        }
    }
}




// return company info
if(!function_exists('get_menus')){
    function menus(){

       return [
             'Home'=>'website.home',
             'About'=>'about.index',
             'About Category'=>'about.sub_content',
             'Contact'=>'contact.index',
             'Event'=>'event.index',
             'Service'=>'service.index',
             'Product'=>'product.index',
             'Job'=>'post.job_list',
             'Report'=>'post.report_list',
            //  'Gallery'=>'gallery.index',
             'Video'=>'video.index',
             'Image'=>'image.index',

    ];
    }
}

// return company info
if(!function_exists('get_sub_menus')){
    function sub_menus(){

       return [
             'Home'=>'website.home',
             'About'=>'about.index',
             'About Category'=>'about.sub_content',
             'Contact'=>'contact.index',
             'Event'=>'event.index',
             'Service'=>'service.index',
             'Product'=>'product.index',
            'Job'=>'post.job_list',
             'Report'=>'post.report_list',
            //  'Gallery'=>'gallery.index',
              'Video'=>'video.index',
             'Image'=>'image.index',
             'File'=>'file.index',

    ];
    }
}




 if(!function_exists('render_image_path')){
    function render_image_path($path){
        return asset('upload/'.$path);
    }

 }

if (!function_exists('banner_types')) {
     function banner_types(){
        return [
            'Product',
            'History',
            'Water_Calculation',
            'water_calculator_details'
        ];
     }
}


if (!function_exists('social_types')) {
     function social_types(){
        return [
            'Partner',
        ];
     }
}

if (!function_exists('slide_show_types')) {
     function slide_show_types(){
        return [
            'Home',
        ];
     }
}



if(!function_exists('upload_file')){
    function upload_file($file){
            $fileName = Str::random(2).'_'.config('app.name').Str::random(2).'_'.time().'.'.$file->extension();
            return $file->storeAs('images',$fileName,'upload');
    }
}


if (!function_exists('delete_file')) {
     function delete_file($path){

        try{
            Storage::disk('upload')->delete($path);
        }catch(Exception $e){
        }

     }
}



if(!function_exists('gallery_types')){
    function gallery_types(){
        return [
            'Image',
            // 'Video',
            'File'
        ];
    }
}


if(!function_exists('gallery_sections')){
    function gallery_sections(){
        return [
            'Gallery',
            'Product'
        ];
    }
}



if(!function_exists('banner_sections')){
    function banner_sections(){
        return [
            // 'Water_Calculation',
            // 'History',
            'Services',
            'Contact',
            'Jobs',
            // 'Products',
            'Events',
            'About',
            'Page',
            'Appointment',
            'Post',
            // 'water_calculator_details'

        ];
    }
}


if(!function_exists('post_sections')){
    function post_sections(){
        return [
            'Client',
            'Privacy',
            'Job',
            'Report',
            'Publication',
            'Disclaimer',
        ];
    }
}



if(!function_exists('price_unit')){
    function price_unit(){
        return [
            'AFN',
            'USD'
        ];
    }
}