<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('size')->nullable();
            $table->string('da_title')->nullable();
            $table->string('pa_title')->nullable();
            $table->integer('price')->nullable();
            $table->integer('real_price')->nullable();
            $table->string('product_unit')->nullable();
            $table->string('price_unit')->nullable();
            $table->text('description');
            $table->text('da_description')->nullable();
            $table->text('pa_description')->nullable();
            $table->string('image')->nullable();
            $table->string('caption_image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};