@extends('Admin.master_page')

@section('small_title')
About
@endsection
@section('content')

                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">About</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  About </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                                   <!-- end page title -->
                        @if(Session::has('message'))
                        <div class="alert alert-info">{{ Session::get('message') }}</div>

                        @endif
                        </div>



                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        @if ($abouts->isEmpty())
                                        <a type="button" href="{{route('abouts.create')}}" class="btn btn-primary ">  Add </a>
                                        </a>
                                        @else
                                        @if ( $about_categories->count()<3)


                                        <a type="button" href="{{route('about_categories.create')}}" class="btn btn-primary ">Add sub content</a>

                                      </a>
                                      @endif
                                        @endif

                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">


<div class="table-responsive">

	<table class="table table-striped">
	<tr>
		<th>Title (English)</th>
		<th>Image</th>
        <th>Description </th>
		<th>Action</th>
	</tr>

	@foreach($abouts as $about)

	<tr>
		<td>
            <p>{{ $about->title }}</p>

        </td>
		<td>
            <img src="{{render_image_path($about->image)}}" width="150" height="100" title="{{ $about->title}} image">
        </td>
        <td>
            <a href="{{ route('abouts.show',$about->id) }}" >
                View
            </a>


        </td>


			<td>
                    <form action="{{route('abouts.destroy' , $about->id)}}" method="post" id="form-{{$about->id}}">
                        {{csrf_field()}}
                        {{method_field("DELETE")}}
                    </form>

                    <a href="{{ route('abouts.edit' , $about->id) }}" ><i class="fas fa-edit"></i></a>

                    &nbsp;
                                   <a href=""
                       onclick="if(confirm('Are you sure to delete?')) {
                               event.preventDefault();
                               document.getElementById('form-{{$about->id}}').submit();
                               }else{ event.preventDefault(); }"
                       ><i class="fas fa-trash-alt"></i></a>
                </td>


	</tr>

	@endforeach

</table>



<br>

</div>
<h5>
    Sub Content
</h5>
<hr>

<div class="table-responsive">

	<table class="table table-striped">
	<tr>
		<th>Title (English) </th>
		<th>Image</th>
		<th>Description</th>
		<th>Action </th>
	</tr>

	@foreach($about_categories as $about_category)

	<tr>
		<td>
            <p>{{ $about_category->title }}</p>

        </td>
        <td>
            <img src="{{render_image_path($about_category->image)}}" width="150" height="100" title="{{ $about_category->title}} image">
        </td>
        <td>
         <a href="{{ route('about_categories.show',$about_category->id) }}" >
                View
            </a>


        </td>



			<td>
                    <form action="{{route('about_categories.destroy' , $about_category->id)}}" method="post" id="form-{{$about_category->id}}">
                        {{csrf_field()}}
                        {{method_field("DELETE")}}
                    </form>

                    <a href="{{ route('about_categories.edit' , $about_category->id) }}" ><i class="fas fa-edit"></i></a>

                    &nbsp;
                                   <a href=""
                       onclick="if(confirm('Are you sure to delete?')) {
                               event.preventDefault();
                               document.getElementById('form-{{$about_category->id}}').submit();
                               }else{ event.preventDefault(); }"
                       ><i class="fas fa-trash-alt"></i></a>
                </td>


	</tr>

	@endforeach

</table>




                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

