@extends('Admin.master_page')

@section('small_title')
Banner
@endsection
@section('content')

                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Banner</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">  Banner </li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                                   <!-- end page title -->
                        @if(Session::has('message'))
                        <div class="alert alert-info">{{ Session::get('message') }}</div>

                        @endif
                        </div>



                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">

                                        <a type="button" href="{{route('banners.create')}}" class="btn btn-primary ">  Add </a>
                                        </a>


                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">


<div class="table-responsive">

	<table class="table table-striped">
	<tr>
		<th>Title</th>
		<th>Section</th>
		<th>English Image</th>
		<th>Dari Image</th>
		<th>Pashto Image</th>
		<th>Action</th>
	</tr>

	@foreach($posts as $item)

	<tr>
		<td>

            <p>
              <a href="{{ route('banners.show',$item->id) }}" >
                  {{ $item->title }}
            </a>
            </p>

        </td>
        <td>
            {{$item->section}}
        </td>
		<td>
            @if ($item->type=='Image')
            <img src="{{render_image_path($item->image)}}" width="150" height="100" title="{{ $item->title}} image">
            @else
            <video autoplay muted  src="{{render_image_path($item->image)}}" width="150" height="100" title="{{ $item->title}} image">
            @endif
        </td>

        <td>
            @if ($item->type=='Image')

            <img src="{{render_image_path($item->da_image)}}" width="150" height="100" title="{{ $item->da_title}} image">
            @else
            <video muted autoplay src="{{render_image_path($item->da_image)}}" width="150" height="100" title="{{ $item->da_title}} image">


            @endif
        </td>
         <td>
            @if ($item->type=='Image')
            <img src="{{render_image_path($item->pa_image)}}" width="150" height="100" title="{{ $item->pa_title}} image">

            @else
            <video muted autoplay src="{{render_image_path($item->pa_image)}}" width="150" height="100" title="{{ $item->pa_title}} image">
            @endif
        </td>



			<td>
                    <form action="{{route('banners.destroy' , $item->id)}}" method="post" id="form-{{$item->id}}">
                        {{csrf_field()}}
                        {{method_field("DELETE")}}
                    </form>

                    <a href="{{ route('banners.edit' , $item->id) }}" ><i class="fas fa-edit"></i></a>

                    &nbsp;
                                   <a href=""
                       onclick="if(confirm('Are you sure to delete?')) {
                               event.preventDefault();
                               document.getElementById('form-{{$item->id}}').submit();
                               }else{ event.preventDefault(); }"
                       ><i class="fas fa-trash-alt"></i></a>
                </td>


	</tr>

	@endforeach

</table>



<br>

</div>





                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

