@extends('Admin.master_page')
@section('small_title')
{{__("dashboard.menu.banner")}}
@endsection

@section('content')
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">{{__("dashboard.menu.banner")}}</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">{{__("dashboard.menu.banner")}}</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>
                            @endif
                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">

                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">


                                              <div class="row">
                                                  @foreach($pagesimages  as $banner)
                                                  <div class="col-xl-4 col-md-6">
                                                      <!-- card -->
                                                      <div class="card card-h-100">
                                                          <!-- card body -->
                                                          <div class="card-body">
                                                              <div class="row align-items-center">
                                                                  <div class="col-12">
                                                                      <p>{{$banner->name}}</p>

                                                                      <img src="{{render_image_path($banner->image)}}" alt="" width="100%">
                                                                      <br>

                                                                  </div>

                                                                  <div class="col-md-4">
                                                                    <a href="{{ route('pagesimages.edit' , $banner->id) }}" ><i class="fas fa-edit"></i></a>
                                                                  </div>

                                                              </div>

                                                          </div><!-- end card body -->
                                                      </div><!-- end card -->
                                                  </div><!-- end col-->
                                                  @endforeach
                                              </div><!-- end row-->

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->
@endsection

