@extends('Admin.master_page')
@section('small_title')
{{__('lable.sub_menu')}}
@endsection

@section('content')



                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Sub Menu</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="{{route('dashboard.index')}}">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Sub Menu</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                            @if(Session::has('message'))
                            <div class="alert alert-info">{{ Session::get('message') }}</div>

                            @endif

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a href="{{ route('submenus.create',['menu'=>$menu->id])}}" class="btn btn-primary">
                                            Add
                                        </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">
                                            <div class="table-responsive mb-0" data-pattern="priority-columns">
                                                <div class="table-responsive">
                                                    <form action="{{route('submenus.order')}}" method="post">
                                                        @csrf

                                                    <table class="table table-striped ">
                                                    <tr>
                                                        <th> Name (English) </th>
                                                        <th> Name (Dari)</th>
                                                        <th> Name (Pashto)</th>
                                                        <th> Resource Type  </th>
                                                        <th>Rotue</th>
                                                        <th> Order</th>

                                                        <th>Action</th>
                                                    </tr>

                                                    @foreach($submenus as $sub_menu)

                                                    <tr>
                                                        <td>
                                                            <p>{{ $sub_menu->sub_menu_name }}</p>
                                                        </td>
                                                         <td>
                                                            <p>{{ $sub_menu->da_sub_menu_name }}</p>
                                                        </td>
                                                         <td>
                                                            <p>{{ $sub_menu->pa_sub_menu_name }}</p>
                                                        </td>
                                                        <td>
                                                            <p>{{ $sub_menu->sub_resource_type }}</p>
                                                        </td>
                                                        <td>
                                                            <p>{{ $sub_menu->sub_route_name }}</p>
                                                        </td>
                                                        <td>

                                                            <p>

                                                                <input type="number" min="1"  onchange="ShowSubmit()" name="sub_menu_orders[{{$sub_menu->id}}]" class="text-center" style="border:1px solid rgb(211, 208, 208);width:50px" value="{{$sub_menu->sub_menu_order}}">
                                                            </p>
                                                        </td>

                                                          <td>
                                                            <a href="{{ route('submenus.edit' , $sub_menu->id) }}" ><i class="fas fa-edit"></i></a>

                                                            &nbsp;
                                                                           <a href="{{route('submenus.delete',['submenu'=>$sub_menu->id])}}"
                                                               onclick="if(!confirm('Are you sure to delete?')) {
                                                                       event.preventDefault();

                                                                       }"
                                                               ><i class="fas fa-trash-alt"></i></a>
                                                        </td>
                                                    </tr>

                                                    @endforeach



                                                </table>
                                                <input type="submit" id="btnSubmit" value="{{__('lable.save_change')}}"  class="btn btn-secondary" style="display:none">

                                                </form>
                                                <br>
                                                        <br>
                                                        <div class="container">

                                                            <div class="row justify-content-center ">

                                                        </div>
                                                        </div>

                                                        <br>
                                                        <br>
                                                        <br>

                                                </div>


                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->



                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->



@endsection

@section('script')
<script>
    function ShowSubmit(){

        let btnSubmit = document.getElementById('btnSubmit');
        btnSubmit.style.display = 'block'

    }

</script>

@endsection
