@extends('website.layout.main')

@section('meta_title')
 Drinking Water
@endsection
@section('content')
            <!-- Hero Section Start -->

    <section class="hero-wrap style6" >
    <div class="hero-slider-three owl-carousel" >
        @foreach ($sliders as $key=>$item)
        <div class="hero-slide-item">
            <img src="{{ render_multiple_image_path($item) }}" class="img-fluid w-100" alt="Slide {{$item->id}}">

        </div>
        @endforeach
    </div>
</section>
            <!-- Hero Section End -->


<section class="product-home" style="background-image: url('{{render_image_path($product_video->url)}}')">
      <div class="container py-5">
        <div class="section-title style1 text-center mb-40">

                        <h2>@lang('front.products')</h2>
                    </div>
        <div class="row">
          <!-- First Column: List of Items -->
          <div class="col-3" style="display: flex;align-items: center">
            <ul class="list-group item-list" style="border: none !important" >
                <li style="display: flex;align-items: center;justify-content: center " class="list-group-item" data-index="0" data-target="{{render_image_path($products[0]->caption_image)}}" id="product{{$products[0]->id}}">
                <div class="row" style="display: flex;align-items: center;justify-content: center ">
                    <div class="col-md-4 ">
                  <img
                  src="{{render_image_path($products[0]->image)}}"
                  alt="{{render_post_title($products[0])}}"
                  class="img-fluid small-image home-product-image"
                />
                    </div>
                    <div class="col-md-6">
                       <h2  class="main-color">
                            {{render_post_title($products[0])}}
                    </h2>
                    </div>
                </div>
              </li>

                 <li class="list-group-item"  data-index="1" data-target="{{render_image_path($products[1]->caption_image)}}" id="product{{$products[1]->id}}">
                <div class="row">
                    <div class="col-md-4">
                  <img
                  src="{{render_image_path($products[1]->image)}}"
                  alt="{{render_post_title($products[1])}}"
                  class="img-fluid small-image home-product-image"
                />
                    </div>
                    <div class="col-md-6">
                       <h2  class="main-color">
                            {{render_post_title($products[1])}}
                    </h2>
                    </div>
                </div>
              </li>

              <!-- Add more items as needed -->
            </ul>
          </div>

          <!-- Center Column: Large Image with Details -->
          <div class="col-6 text-center" style="display: flex; justify-content: center">

               <div class="hero-slider-product owl-carousel" style="display: flex;justify-content: center;direction: ltr !important" >
        @foreach ($products as $key=>$item)
        <div class="hero-slide-item product-hero-item" id="item-product{{$item->id}}">
            <img src="{{ render_multiple_image_path_product($item) }}"  alt="{{render_post_title($item)}}"  class="img-fluid animate-image"  alt="Slide {{$item->id}}">
        </div>
        @endforeach
    </div>


          </div>

          <!-- Last Column: List of Items -->
          <div class="col-3" style="display: flex;align-items: center">
            <ul class="list-group item-list" id="lastColumn">
                  <li class="list-group-item" data-index="2" data-target="{{render_image_path($products[2]->caption_image)}}" id="product{{$products[2]->id}}">
                <div class="row">
                    <div class="col-md-4">
                  <img
                  src="{{render_image_path($products[2]->image)}}"
                  alt="{{render_post_title($products[2])}}"
                  class="img-fluid small-image home-product-image"
                />
                    </div>
                    <div class="col-md-6">
                       <h2  class="main-color">
                            {{render_post_title($products[2])}}
                    </h2>
                    </div>
                </div>
              </li>

              <li class="list-group-item" data-index="3" data-target="{{render_image_path($products[3]->caption_image)}}" id="product{{$products[3]->id}}">
                <div class="row">
                    <div class="col-md-4">
                  <img
                  src="{{render_image_path($products[3]->image)}}"
                  alt="  {{render_post_title($products[3])}} "
                  class="img-fluid small-image home-product-image"
                />
                    </div>
                    <div class="col-md-6">
                       <h2  class="main-color">
                            {{render_post_title($products[3])}}
                    </h2>
                    </div>
                </div>
              </li>
              <!-- Add more items as needed -->
            </ul>
          </div>
        </div>
      </div>

</section>
{{-- Start Product  --}}

    <!-- Video Background -->


{{-- End Product --}}

     <section class="service-wrap ptb-50 bg-athens">
                <div class="container">
                    <div class="section-title style1 text-center mb-40">
                        <h2>@lang('front.services')</h2>
                    </div>
                    <div class="service-slider-one owl-carousel">

                        @foreach ($services as $item)
                          <div class="service-card style1"  data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                            <div class="service-img">
                                <img src="{{render_image_path($item->image)}}" alt="Image" style="height: 263px">

                            </div>
                            <div class="service-info">
                                <h3><a href="{{render_route('service.show',$item->id)}}">
                                {{render_post_title($item)}}
                                </a></h3>
                                <p>
                                    {{strip_tags(str()->words(render_post_description($item),20))}}
                                </p>
                                <a href="{{render_route('service.show',$item->id)}}" class="link style2">@lang('front.more')</a>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="text-center mt-30">
                        <p class="mb-0"><a href="{{render_route('service.index')}}" class="link style1">@lang('front.services_more')</a></p>
                    </div>
                </div>
            </section>

{{-- Vedio Section Start --}}
{{-- Video --}}


{{-- Start Our History --}}

      <section >
                    <div class="row align-items-center text-center no-gutters  g-0">
                        <div class="col-lg-4 align-items-center"   data-aos="fade-right" data-aos-duration="1200" data-aos-delay="200">
                            <div class="text-center water-cal align-items-center history-text-section row" style="background-image: url({{render_multiple_image_path($water_calculator)}})">
                               <div class="col-10 section-title style2">
                                <span >@lang('front.water_calculator')</span>
                                <h2 style="color: white !important" >{{render_post_title($water_calculator)}}</h2>
                                <a href="{{render_route('water.calculate')}}" class="btn style1 history-btn">
                                   @lang('front.calculat_now')
                                </a>
                            </div>
                            </div>
                        </div>
                        <div class="col-lg-8" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                            <div class="history-home align-items-center history-text-section row" style="background-image: url({{render_multiple_image_path($history)}})">
                               <div class="col-10 section-title style2">
                                <span >@lang('front.our-history')</span>
                                   <h2 style="color: white !important">{{render_post_title($history)}}</h2>
                                   <p >
                                    {{strip_tags(str()->words(render_post_description($history),30))}}
                                   </p>
                                   <a href="{{render_route('banner.show',$history->id)}}" class="btn style1 history-btn">@lang('front.more')</a>
                               </div>
                            </div>

                        </div>
                    </div>

            </section>

{{-- End Our Histroy  --}}




{{-- Start Client --}}

@include('website.partial.__client')

{{-- End Client --}}


{{-- Start Order --}}
  @include('website.partial.__order')
{{-- End Order  --}}



{{-- Start Events --}}
      <section class="blog-wrap ptb-100 ">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-7 col-md-8">
                            <div class="section-title style1 mb-40">
                                <h2>
                                    @lang('front.event')
                                </h2>
                            </div>
                        </div>
                    </div>
                    <div class="blog-slider-one owl-carousel">

                         @foreach ($events as $item)
                            <div class="blog-card style1" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                            <div class="blog-img">
                                <img src="{{render_image_path($item->image)}}" style="max-height: 237px" alt="Image">
                            </div>
                            <div class="blog-info">
                                <a href="{{render_route('event.show',$item->id)}}"  class="blog-date">
                                    {{render_date($item->start_date)}}
                                </a>
                                <ul class="blog-metainfo  list-style">
                                    <li>
                                        <i class="flaticon-map"></i>
                                        {{$item->location}}

                                    </li>
                                </ul>
                                <h3 style="height: 50px"><a href="{{render_route('event.show',$item->id)}}">
                                    {{render_post_title($item)}}
                                </a></h3>
                                <a href="{{render_route('event.show',$item->id)}}" class="link style2">@lang('front.more')
                                </a>
                            </div>
                        </div>
                         @endforeach
                    </div>
                </div>
            </section>

{{-- End Events  --}}


{{-- Start Social --}}

  <section class="ptb-50 bg-athens">
    <div class="container text-center ">
       <h2>
        @lang('front.media')
       </h2>
        <div class="row g-1">
            @foreach ($socials as $item)
            <div class="col-md-2 col-6" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <a href="{{$item->url}}" target="__blank">
                    <img src="{{render_multiple_image_path($item)}}"  style="width: 100%; height: 120px"/>
                </a>
            </div>
            @endforeach

        </div>
    </div>


  </section>
{{-- End Social --}}





@endsection

@push('scripts')

<script src="{{asset('assets/cutome/app.js')}}"></script>
@endpush
