@extends('website.layout.main')
@section('small_title', 'Con ')
@section('content')
 <!-- Start Contact Area -->
 <section class="contact-section ptb-100">
    <div class="container">
        <div class="row">

            <div class="col-lg-10 col-md-10">
                <div class="contact-area">
                    <div class="contact-content">
                        <h3>Apply for the job ({{$job->title}})</h3>
                    </div>

                     @if (Session::has('success_message'))
                       <p style="color:green">
                        {{Session::get('success_message')}}

                       </p>
                     @endif

                    <div class="contact-form">
                        <form action="{{route('sjobs.store')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="job_id" value="{{$job->id}}"/>
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="firstName" id="name" class="form-control"  data-error="Please enter your name" placeholder="First Name">
                                        @error('firstName')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="lastName" id="name" class="form-control"  data-error="Please enter your last name" placeholder="Last Name">
                                        @error('lastName')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <input type="email" name="email" id="email" class="form-control"  data-error="Please enter your email" placeholder="Email">
                                        @error('email')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">

                                    <div class="form-group">

                                       <select class="form-control"  name="gender">
                                        <option value="">__Select Gender__</option>
                                         <option >Male</option>
                                         <option >Female</option>
                                       </select>
                                        @error('gender')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="phoneNumber" id="phone_number"  data-error="Please enter your number" class="form-control" placeholder="Phone">
                                        @error('phoneNumber')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <span>Your cv must be type of pdf</span>
                                    <div class="form-group">
                                        <input type="file" name="file" id="subjects" class="form-control"  data-error="Please upload your cv" placeholder="Subjects">
                                        @error('file')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <textarea name="coverLetter" class="form-control" id="message" cols="30" rows="6"  data-error="Write your message" placeholder="Write Something"></textarea>
                                        @error('coverLetter')
                                        <div style="color: red">
                                            {{$message}}
                                        </div>
                                        @enderror
                                    </div>
                                </div>




                                <div class="col-lg-12">
                                    <div class="send-btn">
                                        <button type="submit" class="default-btn">
                                            Apply
                                            <i class="flaticon-right"></i>
                                            <span></span>
                                        </button>
                                    </div>
                                    <div id="msgSubmit" class="h3 text-center hidden"></div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Contact Area -->
@endsection

    <!-- Main Footer -->
