@extends('website.layout.main')
@section('small_title', 'On going projects')
@section('content')
    <!-- Start Causes Area -->
    <section class="causes-section pt-100 pb-100">
        <div class="container">
            <div class="section-title">
                <h2>Projects</h2>
            </div>

            <div class="row">
                @foreach ($projects as $item)
                <div class="col-lg-4 col-md-6">
                    <div class="single-causes">
                        <img src="{{render_image_path($item->image)}}"  alt="image"  style="height: 420px">


                        <div class="causes-content">

                            <h3>
                                {{$item->title}}
                            </h3>
                            <p>
                                {!! str()->words($item->description,10)!!}
                            </p>


                            <div class="causes-progress-bar">
                                <div class="causes-progress-content">
                                    <span>
                                        <i class="flaticon-pin"></i>
                                        {{$item->province->en_name}}
                                    </span>

                                    <div class="text-right">
                                        <span>
                                          Start date:
                                            {{$item->start_date}}
                                        </span>

                                    </div>
                                </div>

                            </div>

                            <a href="{{route('sprojects.show',$item->id)}}" class="causes-btn-one">
                                Read more ...
                                <i class="flaticon-right"></i>
                            </a>
                        </div>
                    </div>
                </div>

                @endforeach

                <div class="col-lg-12 col-md-12">
                    <div class="pagination-area">
                       {{$projects->links()}}
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Causes Area -->

@endsection


    <!-- Main Footer -->
