<?php


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\website\EventController;
use App\Http\Controllers\admin\UserController ;
use App\Http\Controllers\website\PageController;
use App\Http\Controllers\admin\CompanyController;
use App\Http\Controllers\admin\SettingController;
use App\Http\Controllers\website\AboutController;
use App\Http\Controllers\website\GalleryController;
use App\Http\Controllers\website\ProductController;
use App\Http\Controllers\website\ServiceController;

use App\Http\Controllers\admin\PagesImageController;

use App\Http\Controllers\website\LanguageController;
use App\Http\Controllers\admin\HomeController as AdminHomeController;
use App\Http\Controllers\admin\MenuController as AdminMenuController;
use App\Http\Controllers\admin\WhatController as AdminWhatController;
use App\Http\Controllers\admin\AboutController as AdminAboutController;
use App\Http\Controllers\admin\EventController as AdminEventController;
use App\Http\Controllers\admin\BannerController as AdminBannerController;
use App\Http\Controllers\admin\SocialController as AdminSocialController;
use App\Http\Controllers\website\HomeController as WebsiteHomeController;
use App\Http\Controllers\admin\ProductController as AdminProductController;
use App\Http\Controllers\admin\ServiceController as AdminServiceController;
use App\Http\Controllers\admin\SubmenuController as AdminSubmenuController;
use App\Http\Controllers\admin\ActivityController as AdminActivityConroller;
use App\Http\Controllers\admin\SlideShowController as AdminSlideShowController;
use App\Http\Controllers\admin\ImageGalleryController as AdminImageGallaryController;
use App\Http\Controllers\admin\AboutCategoryController as AdminAboutCategoryController;
use App\Http\Controllers\admin\CounterController as AdminCounterController;
use App\Http\Controllers\admin\PostController as AdminPostController;
use App\Http\Controllers\website\BannerController;
use App\Http\Controllers\website\ContactController;
use App\Http\Controllers\website\PostController;
use Spatie\Honeypot\ProtectAgainstSpam;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|s
*/


// website routes




Route::get('aict',[LoginController::class,'ShowLoginForm'])->name('aict');


Route::get('/', [LanguageController::class,'checklang']);

Route::prefix('/{lang}')->middleware('local')->group(function () {
    Route::get('/',[WebsiteHomeController::class,'index'])->name('website.home');
    Route::get('/change_locale/{local}',[LanguageController::class,'changeLocal'])->name('local.change');
    Route::get('/service',[ServiceController::class,'index'])->name('service.index');
    Route::get('/service/{id}',[ServiceController::class,'show'])->name('service.show');
    Route::get('/gallerie',[GalleryController::class,'index'])->name('gallery.index');
    Route::get('/product',[ProductController::class,'index'])->name('product.index');
    Route::get('/water-calculate',[ProductController::class,'water_calculate'])->name('water.calculate');


    Route::get('/branche',[ProductController::class,'index'])->name('branche.index');
    Route::get('/branche/{id}',[ProductController::class,'show'])->name('branche.show');



      Route::get('/job',[PostController::class,'job_list'])->name('post.job_list');
    Route::get('/job/{id}',[PostController::class,'job_show'])->name('post.job_show');


      Route::get('/report',[PostController::class,'report_list'])->name('post.report_list');
    Route::get('/report/{id}',[PostController::class,'report_show'])->name('post.report_show');



    Route::post('product/order',[ProductController::class,'order'])->name('product.order')->middleware(ProtectAgainstSpam::class);
    Route::get('post/{id}',[PageController::class,'show'])->name('pages.show');

    Route::get('about',[AboutController::class,'index'])->name('about.index');
    Route::get('privacy',[AboutController::class,'privacy'])->name('about.privacy');

    Route::get('disclaimer',[AboutController::class,'disclaimer'])->name('about.disclaimer');

    Route::get('about/{id}',[AboutController::class,'content'])->name('about.content');


    Route::get('news',[EventController::class,'index'])->name('event.index');
    Route::get('news/{id}',[EventController::class,'show'])->name('event.show');
    Route::get('contact',[ContactController::class,'index'])->name('contact.index');
    Route::post('contact',[ContactController::class,'sendMessage'])->name('contact.store')->middleware(ProtectAgainstSpam::class);
    Route::get('banner/{id}',[BannerController::class,'show'])->name('banner.show');

    Route::get('image',[GalleryController::class,'image'])->name('image.index');
    Route::get('video',[GalleryController::class,'video'])->name('video.index');
    Route::get('file',[GalleryController::class,'file'])->name('file.index');



});






// Admin

// Dashboard
Route::middleware('auth')->group(function () {

    Route::resource('admin/abouts', AdminAboutController::class);
    Route::get('admin/dashboard',[AdminHomeController::class,'dashboard'])->name('dashboard.index');

    Route::resource('admin/users',UserController::class);


    Route::resource('admin/services',AdminServiceController::class);
    Route::resource('admin/posts',AdminPostController::class);
    Route::resource('admin/socials',AdminSocialController::class);


    Route::resource('admin/imageGallaries', AdminImageGallaryController::class);

    Route::resource('admin/slideShows', AdminSlideShowController::class);

    Route::resource('admin/about_categories', AdminAboutCategoryController::class);
    Route::resource('admin/banners',AdminBannerController::class);

    Route::resource('admin/news', AdminWhatController::class);

    Route::resource('admin/activities', AdminActivityConroller::class);

    Route::resource('admin/pagesimages', PagesImageController::class);
    Route::get('admin/pagesimages/delete/{id}',[PagesImageController::class,'delete'])->name('pagesimages.delete');

    Route::resource('admin/companies',CompanyController::class);



    Route::resource('admin/events',AdminEventController::class);
    Route::resource('admin/counters',AdminCounterController::class);
    Route::resource('admin/products',AdminProductController::class);




    Route::resource('admin/menus', AdminMenuController::class);
    Route::get('admin/menus/delete/{menu}', [AdminMenuController::class,'delete'])->name('menus.delete');
    Route::post('admin/menus/order', [AdminMenuController::class,'order'])->name('menus.order');


    Route::resource('admin/submenus', AdminSubmenuController::class);
    Route::get('admin/submenus/create/{menu}', [AdminSubmenuController::class,'create'])->name('submenus.create');
    Route::get('admin/submenus/delete/{submenu}', [AdminSubmenuController::class,'delete'])->name('submenus.delete');
    Route::post('admin/submenus/order', [AdminSubmenuController::class,'order'])->name('submenus.order');

   Route::get('settings',[SettingController::class,'index'])->name('settings.index');

   Route::put('settings',[SettingController::class,'update'])->name('settings.update');


});

// Auth

Route::post('aict',[LoginController::class,'Login']);
Route::post('logout',[LoginController::class,'logout'])->name('logout');
