<?php $__env->startSection('small_title'); ?>
Gallery
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Gallery</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Gallery</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            <?php if(Session::has('message')): ?>
                            <div class="alert alert-info"><?php echo e(Session::get('message')); ?></div>

                            <?php endif; ?>

                        </div>
                        <!-- end page title -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <a type="button" href="<?php echo e(route('imageGallaries.create')); ?>" class="btn btn-primary "> Add </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-rep-plugin">


                                              <div class="row">
                                                  <?php $__currentLoopData = $imageGallaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageGallary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                  <div class="col-xl-4 col-md-6">
                                                      <!-- card -->
                                                      <div class="card card-h-100">
                                                          <!-- card body -->
                                                          <div class="card-body">
                                                              <div class="row align-items-center">
                                                                  <div class="col-12">
                                                                      <p><?php echo e($imageGallary->title); ?></p>

                                                                      <?php if($imageGallary->type =='Image'): ?>

                                                                      <img src="<?php echo e(render_image_path($imageGallary->url)); ?>" alt="" width="100%">
                                                                      <?php elseif($imageGallary->type =='File'): ?>
                                                                        <p>
                                                                            <a href="<?php echo e(render_image_path($imageGallary->url)); ?>" download>
                                                                                Download
                                                                            </a>
                                                                        </p>
                                                                      <?php else: ?>

                                                                        <video  muted autoplay loop  src="<?php echo e(render_image_path($imageGallary->url)); ?>" alt="" width="100%"></video>
                                                                      <?php endif; ?>
                                                                      <br>

                                                                  </div>

                                                                  <hr>
                                                                  <div class="col-md-4">
                                                                      <form action="<?php echo e(route('imageGallaries.destroy' , $imageGallary->id)); ?>" method="post" id="form-<?php echo e($imageGallary->id); ?>">
                                                                          <?php echo e(csrf_field()); ?>

                                                                          <?php echo e(method_field("DELETE")); ?>

                                                                      </form>

                                                                      <a href="<?php echo e(route('imageGallaries.edit' , $imageGallary->id)); ?>" ><i class="fas fa-edit"></i></a>

                                                                      &nbsp;
                                                                                     <a href=""
                                                                         onclick="if(confirm('Are you sure to delete?')) {
                                                                                 event.preventDefault();
                                                                                 document.getElementById('form-<?php echo e($imageGallary->id); ?>').submit();
                                                                                 }else{ event.preventDefault(); }"
                                                                         ><i class="fas fa-trash-alt"></i></a>
                                                                  </div>

                                                              </div>

                                                          </div><!-- end card body -->
                                                      </div><!-- end card -->
                                                  </div><!-- end col-->
                                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                              </div><!-- end row-->

                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <!-- end card -->
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('Admin.master_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\2025\laravel\MAMI\resources\views/Admin/image_gallery/index.blade.php ENDPATH**/ ?>