
<!DOCTYPE html>
<html lang="<?php echo e(appLocal()); ?>" dir="<?php echo e(get_direction()); ?>">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo e(company()->description); ?>">
    <link rel="icon" type="image/png" href="<?php echo e(render_logo_path(company())); ?>">
    <title> <?php echo $__env->yieldContent('meta_title'); ?>- <?php echo e(company()->name); ?> </title>
        <!-- Link of CSS files -->
        <?php if(is_rtl()): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/bootstrap-rtl.min.css')); ?>">
         <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/flaticon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/remixicon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.carousel.min.css')); ?>">


        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/odometer.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/aos.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/style.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css_rtl/responsive.css')); ?>">

        <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
         <link rel="stylesheet" href="<?php echo e(asset('assets/css/flaticon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/remixicon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.carousel.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/odometer.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/aos.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>">
        <?php endif; ?>



        <link rel="stylesheet" href="<?php echo e(asset('assets/cutome/style.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/cutome/product.css')); ?>">

        <?php echo $__env->yieldContent('style'); ?>

        <style>
            .header-wrap .navbar .navbar-nav .nav-item a {
                font-weight: bold;
                color: #044f9f;

            }

          h2, h2.main-color, h3 a, .link.style1, h1, h4{
                color: #044f9f !important;
            }

            h3 a:hover {
                color: #0090be !important;
            }

            .company-background {
                background-color: #044f9f;
            }

            .company-background h2 {
                color: white !important;
            }
            .product-home {
                height: 800px;
                background-position: center;
                background-repeat: no-repeat;
                background-size: cover;
                width: 100%;
                margin: -5px 0;

            }

            .hero-slider-product .owl-nav {
                display: none !important;
            }
            @media (max-width:768px){

             .hero-slider-product .owl-nav {
        display: flex !important;
        justify-content: space-between;
        position: absolute;
        top: 50%;
        width: 100%;
        transform: translateY(-50%);
        pointer-events: none;
    }

   .hero-slider-product .owl-nav i {
        font-size: 24px;
        pointer-events: auto; /* Make sure icons are clickable */
    }

                .hero-wrap{
                    margin-top: 20px !important;
                }
            }
        </style>

    </head>
    <body>



        <!-- Page Wrapper End -->
        <div class="page-wrapper">

            <!-- Header Section Start -->
            <header class="header-wrap style1">
                <div class="header-top">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <div class="header-top-left">
                                    <ul class="contact-info list-style">
                                        <li>
                                            <span>
                                                <i class="flaticon-email-1"></i></span>
                                            <a href="mailto:<?php echo e(company()->email1); ?>"><?php echo e(company()->email1); ?></a>
                                        </li>
                                        <li>
                                            <span><i class="ri-phone-fill"></i></span>
                                            <a href="tel:<?php echo e(company()->phone1); ?>" style="direction: ltr !important"><?php echo e(company()->phone1); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="header-top-right">
                                    <div class="select-lang">
                                        <i class="ri-earth-fill"></i>
                                        <div class="navbar-option-item navbar-language dropdown language-option">
                                            <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown"
                                                aria-haspopup="true" aria-expanded="false">
                                                <span >
                                                   <?php echo e(get_available_langs()[appLocal()]); ?>

                                                </span>
                                            </button>
                                            <div class="dropdown-menu language-dropdown-menu">
                                                <?php $__currentLoopData = get_available_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                     <a class="dropdown-item" href="<?php echo e(render_route('local.change',$key)); ?>">
                                                     <?php echo e($item); ?>

                                                </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <ul class="social-profile list-style style1">
                                        <li>
                                            <a href="<?php echo e(company()->facebook); ?>" target="__blank">
                                                <i class="ri-facebook-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(company()->twitter); ?>" target="__blank">
                                                <i class="ri-twitter-fill"></i>
                                            </a>
                                        </li>
                                          <li>
                                            <a  href="<?php echo e(company()->instagram); ?>" target="__blank">
                                                <i class="ri-instagram-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(company()->linkedin); ?>" target="__blank">
                                                <i class="ri-linkedin-fill"></i>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="header-bottom">
                    <div class="container">
                        <nav class="navbar navbar-expand-md navbar-light">
                           <a class="navbar-brand" href="<?php echo e(url("/".appLocal())); ?>">
                                <img class="logo-light" style="height: 60px;" src="<?php echo e(render_logo_path(company())); ?>" alt="logo">
                            </a>
                            <div class="collapse navbar-collapse main-menu-wrap" id="navbarSupportedContent">
                                <div class="menu-close d-lg-none">
                                    <a href="javascript:void(0)"> <i class="ri-close-line"></i></a>
                                </div>
                                <ul class="navbar-nav ms-auto">

                                    <?php $__currentLoopData = get_menus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <li class="nav-item" >
                                         <a href="<?php echo e(render_menu_url($item)); ?>" class="nav-link"><?php echo e(render_menu_name($item)); ?>

                                            <?php if(count($item->sub_menus)>0): ?>
                                            <i class="ri-arrow-down-s-line"></i>
                                            <?php endif; ?>
                                         </a>
                                         <?php if(count($item->sub_menus)>0): ?>
                                         <ul class="dropdown-menu">
                                              <?php $__currentLoopData = $item->sub_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li class="nav-item">

                                                <a href="<?php echo e(render_sub_menu_url($sub_item)); ?>" class="nav-link">

                                                      <?php if($sub_item->sub_menu_icon): ?>
                                                         <?php echo $sub_item->sub_menu_icon; ?>

                                                     <?php endif; ?>

                                                     <?php echo e(render_sub_menu_name($sub_item)); ?>




                                                </a>
                                            </li>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                         <?php endif; ?>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item d-lg-none">
                                        <a href="#orders" class="nav-link btn style1"><?php echo e(__('front.order')); ?></a>
                                    </li>
                                </ul>
                                <div class="other-options md-none">
                                    
                                    <div class="option-item">
                                        <a href="#orders" class="btn style2"><?php echo e(__('front.order')); ?></a>
                                    </div>
                                </div>

                            </div>
                        </nav>
                        
                        <div class="mobile-bar-wrap">
                            
                            <div class="mobile-menu d-lg-none">
                                <a href="javascript:void(0)"><i class="ri-menu-line"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <!-- Header Section End -->



<?php /**PATH D:\project_backup_2024-10-08\htdocs\2024\projects\laravel\aria_water\resources\views/website/layout/header.blade.php ENDPATH**/ ?>