<!DOCTYPE html>
<html lang="zxx" lang="<?php echo e(appLocal()); ?>" dir="<?php echo e(get_direction()); ?>">

<head>
    <!--=== Meta Tags ===-->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php if(is_rtl()): ?>
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/meanmenu.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/boxicons.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/fonts/flaticon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/nice-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/magnific-popup.min.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/style.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/responsive.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/bootstrap.rtl.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('rtl/assets/css/rtl.css')); ?>" />
    <style>
        a {
            text-decoration: none !important;
        }
    </style>


    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/meanmenu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/boxicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/flaticon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/odometer.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/nice-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/magnific-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>">

    <?php endif; ?>


    <link
  rel="stylesheet"
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
  crossorigin="anonymous"
/>

    <!--=== Title & Favicon ===-->

    <title> <?php echo $__env->yieldContent('meta_title'); ?> <?php echo e(company()?->name); ?> </title>

    <meta name="description" content="<?php echo e(company()->description); ?>">

    <link rel="icon" type="image/png" href="<?php echo e(render_logo_path(company())); ?>">


    <style>
      @media (min-width: 768px) {
  .banner-content {
    padding: 0 30px !important;
  }
      }

      .footer-logo ul li a i,.footer-logo ul li i {
        color: #f5f1e6 !important;
      }


       .footer-logo ul li a:hover, .footer-links ul li a:hover {
         color: #006B3C !important
       }

       /* .rules-area .container .rules-item ul li {
        list-style-type: none;
    display: block;
    padding-left: 20px;
    font-weight: 600;
    position: relative;
    margin-bottom: 12px;
       } */

       /* .rules-area .container .rules-item ul li:before{
           position: absolute !important;
    content: "" !important;
    width: 10px !important;
    height: 10px !important;
    top: 7px !important;

    left: 0 !important;
    background-color: #003366 !important;
       } */

    </style>



</head>

<body>
    <!-- Preloader -->
    
    <!-- End Preloader -->

    <!-- Header -->
    <div class="header-area two">
        <div class="container">
            <div class="row align-items-center">

                <div class="col-lg-10">
                    <div class="left">
                        <ul>
                            <li>
                                    <i class="bx bx-phone-call"></i>


                                <a href="tel:<?php echo e(company()->phone1); ?>">
                                            <?php echo e(company()->phone1); ?>

                                        </a>
                            </li>
                            <li>
                                <i class="bx bx-mail-send"></i>
                                <a href="mailto:<?php echo e(company()->email1); ?>">
                                    <?php echo e(company()->email1); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-2">
                    <div class="right">
                        <ul>
                            <li>
                                <a href="<?php echo e(company()->facebook); ?>" target="_blank">
                                       <i class="fa-brands fa-facebook-f" aria-hidden="true"></i>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(company()->twitter); ?>" target="_blank">
                                                             <i class="fa-brands fa-x-twitter" aria-hidden="true"></i>

                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(company()->linkedin); ?>" target="_blank">
                                     <i class="fa-brands fa-linkedin-in" aria-hidden="true"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Header -->

    <!-- Navbar -->
    <div class="navbar-area sticky-top">
        <!-- Menu For Mobile Device -->
        <div class="mobile-nav">
            <a href="<?php echo e(url('/')); ?>" class="logo">
                <img src="<?php echo e(render_logo_path(company())); ?>" alt="Logo">
            </a>
        </div>

        <!-- Menu For Desktop Device -->
        <div class="main-nav two">
            <div class="container">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="/">
                        <img src="<?php echo e(render_logo_path(company())); ?>" alt="Logo">
                    </a>
                    <div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent" style="display: block;">


                            <ul class="navbar-nav">

                                    <?php $__currentLoopData = get_menus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <li class="nav-item" >
                                         <a href="<?php echo e(render_menu_url($item)); ?>" class="nav-link <?php echo e($item->sub_menus? 'dropdown-toggle':''); ?>"><?php echo e(render_menu_name($item)); ?>

                                            <?php if(count($item->sub_menus)>0): ?>

                                             <i class="bx bx-chevron-down"></i>
                                            <?php endif; ?>
                                         </a>
                                         <?php if(count($item->sub_menus)>0): ?>
                                         <ul class="dropdown-menu">
                                              <?php $__currentLoopData = $item->sub_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li class="nav-item">

                                                <a href="<?php echo e(render_sub_menu_url($sub_item)); ?>" class="nav-link">

                                                      <?php if($sub_item->sub_menu_icon): ?>
                                                         <?php echo $sub_item->sub_menu_icon; ?>

                                                     <?php endif; ?>

                                                     <?php echo e(render_sub_menu_name($sub_item)); ?>




                                                </a>
                                            </li>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                         <?php endif; ?>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>

                        <div class="side-nav">
                            <div class="language">
                                
                                <div class="nice-select" tabindex="0"><span class="current">
                                     <?php echo e(get_available_langs()[appLocal()]); ?>

                                </span>
                                    <ul class="list">
                                        <?php $__currentLoopData = get_available_langs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li data-value="English" class="option selected">
                                             <a  href="<?php echo e(render_route('local.change',$key)); ?>">
                                                     <?php echo e($item); ?>

                                                </a>

                                        </li>



                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </ul>
                                </div>
                            </div>
                            <a class="consultant-btn" href="<?php echo e(render_route('contact.index')); ?>">
                                <?php echo app('translator')->get('front.contact'); ?>
                            </a>
                        </div>


                        

                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Navbar -->
<?php /**PATH /home/wssupport/app.mami/resources/views/website/layout/header.blade.php ENDPATH**/ ?>