<?php

namespace App\Http\Controllers\Admin;

use App\Models\Job;
use App\Models\Applicant;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;

class ApplicantController extends Controller
{
    public function index($id){

        $job = Job::with('applicants')->find($id);
        return view('Admin.applicant.index',compact('job'));
    }

    public function show($id,$applicant){

        $job = Job::with('applicants')->find($id);
        $applicant =Applicant::with('jobs')->find($applicant);
        return view('Admin.applicant.show',compact('job','applicant'));
    }

    public function destroy(Applicant $applicant)
    {
        if($applicant->resume){
           try{
            unlink($applicant->resume);
            $message = show_success();
           }catch(Exception $e){
            $message = $e->getMessage();
           }
        }
        if($applicant->delete()){
            return redirect()->route('jobs.index')->with('message',$message);
        }
    }


}
