<?php

namespace App\Http\Controllers\admin;

use App\Models\Banner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Media\StoreBannerRequest;
use App\Http\Requests\Media\UpdateBannerRequest;

class BannerController extends Controller
{
     public function index(Request $request)
    {
        $posts = Banner::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.banner.index',compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('Admin.banner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBannerRequest $request)
    {



         Banner::create($request->requestHandler());
        return redirect()->route('banners.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $post = Banner::find($id);
        return view('Admin.banner.show',compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = Banner::find($id);

        return view('Admin.banner.edit',compact('post'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBannerRequest $request, $id)
    {
        $banner = Banner::findOrFail($id);

        $banner->update($request->requestHandler());

         return redirect()->route('banners.index')->with('message',
            show_success());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $banner = Banner::find($id);
        if($banner->image){
          delete_file($banner->image);
        }

          if($banner->da_image){
          delete_file($banner->da_image);
        }
          if($banner->pa_image){
          delete_file($banner->pa_image);
        }

        if($banner->delete()){
            return redirect()->route('banners.index')->with('message',show_success());
        }
    }
}