<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Counter;
use Illuminate\Http\Request;


class CounterController extends Controller
{
    public function index()
    {


        $counters = Counter::latest()->paginate(12);

        return view('Admin.counters.index' , compact('counters'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Admin.counters.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        Counter::create($request->all());
        return redirect()->route('counters.index')->with('message' , 'Record Successfully Created!');
    }



    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Counter $counter)
    {
        return view('Admin.Counter.edit' , compact('counter'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Counter $counter)
    {
        $counter->update($request->all());
        return redirect()->route('counters.index')->with('message' , 'Record Successfully Updated!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Counter $counter)
    {

        $counter->delete();
        return redirect()->route('counters.index')->with('message' , 'Record Successfully Deleted!');
    }
}
