<?php

namespace App\Http\Controllers\admin;

use App\Models\ImageGallary;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Media\StoreImageGalleryRequest;
use App\Http\Requests\Media\UpdateImageGalleryRequest;


class ImageGalleryController extends Controller
{
    public function index(Request $request)
    {

        $imageGallaries = ImageGallary::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.image_gallery.index',compact('imageGallaries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.image_gallery.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreImageGalleryRequest $request)
    {
             ImageGallary::create($request->requestHandler());
           return redirect()->route('imageGallaries.index')->with('message',show_success());

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $imageGallary= ImageGallary::find($id);
        return view('Admin.image_gallery.edit',compact('imageGallary'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateImageGalleryRequest $request, $id)
    {
           $ImageGallary = ImageGallary::find($id);
            $ImageGallary->update($request->requestHandler());
            return redirect()->route('imageGallaries.index')->with('message',
            show_success());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ImageGallary  = ImageGallary::findOrFail($id);
        if($ImageGallary->url){
            delete_file($ImageGallary->url);
        }
        if($ImageGallary->delete()){
            return redirect()->route('imageGallaries.index')->with('message',show_success());
        }
    }



}