<?php

namespace App\Http\Controllers\admin;

use App\Models\Project;
use App\Models\Province;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;

class ProjectController extends Controller
{
    public function index(Request $request)
    {
        if($search = $request->search){
          $projects = Project::where('title','LIKE',"%{$search}%")->paginate(config('aictcms.pageNumber'))->withQueryString();
        }else{
        $projects = Project::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        }
       
        return view('Admin.projects.index',compact('projects'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $provinces = Province::get();
        
    
        return view('Admin.projects.create',compact('provinces'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


               $request->validate([
                'title'=>'required',
                'description'=>'required',
                'status'=>'required',
                'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
              ]);

           // image store
              if($request->hasFile('image')){
                $imageName = time().'.'.$request->image->extension();
                $imagePath = $request->image->move('images/projects',$imageName);
                $imagePath = str_replace("\\", "/", $imagePath);

              }else{
               $imagePath = null;
              }

           project::create([
            'title'=>$request->title,
            'start_date'=>$request->start_date,
            'end_date'=>$request->end_date,
            'mission_description'=>$request->mission_description,
            'description'=>$request->description,
            'province_id'=>$request->province_id,
            'status'=>$request->status,
            'image'=>$imagePath
           ]);

           return redirect()->route('projects.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(project $project)
    {
        return view('Admin.projects.show',compact('project'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(project $project)
    {


        $provinces = Province::get();


        return view('Admin.projects.edit',compact('project','provinces'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

           $project = project::findOrFail($id);

           $request->validate([
            'title'=>'required',
            'description'=>'required',
            'status'=>'required',
            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
           ]);

           // image update
          if($request->hasFile('image')){
            if($project->image){
                try{
                    unlink($project->image);


                    }catch(Exception $e){

                    }
            }


             $imageName = time().'.'.$request->image->extension();
             $imagePath = $request->image->move('images/projects',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);
          }else{

           $imagePath = $project->image;
       }

        // upate
        $project->title=$request->input('title');
        $project->start_date=$request->input('start_date');
        $project->end_date=$request->input('end_date');
        $project->province_id=$request->input('province_id');
        $project->description = $request->input('description');
        $project->status = $request->input('status');
        $project->mission_description = $request->input('mission_description');
        $project->image = $imagePath;

        if($project->save()){
            return redirect()->route('projects.index')->with('message',
            show_success());
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(project $project)
    {

        if($project->image){

            try{
            unlink($project->image);


            }catch(Exception $e){

            }
        }

        if($project->delete()){
            return redirect()->route('projects.index')->with('message',show_success());
        }
    }

    public function deleteImage($id){
         $project = project::findOrFail($id);
         if($project->image){

             try{
               unlink($project->image);
               $message = show_success();
             }catch(Exception $e){
                $message = $e->getMessage();
             }
            $project->image = '';
            $project->save();
            return redirect()->route('projects.edit',['project'=>$id])->with('message',$message);
         }

    }
}