<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProvinceRequest;
use App\Models\Province;
use Illuminate\Http\Request;

class ProvinceController extends Controller
{
    public function index(){
        $provinces = Province::orderBy('en_name')->get();
        return view('Admin.Province.index',compact('provinces'));
    }

    public function edit(Province $province){

      return view('Admin.Province.edit',compact('province'));
    }

    public function update(Request $request, Province $province)
    {


        $data = $request->all();

        $province->update($data);
        return redirect()->route('provinces.index')->with('success_message' , 'Record Successfully Updated!');
    }
}
