<?php

namespace App\Http\Controllers\admin;

use App\Models\Social;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Media\StoreSocialRequest;
use App\Http\Requests\Media\UpdateSocialRequest;

class SocialController extends Controller
{

      public function index(Request $request)
    {
        $posts = Social::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.social.index',compact('posts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('Admin.social.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreSocialRequest $request)
    {
         Social::create($request->requestHandler());
        return redirect()->route('socials.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $post = Social::find($id);
        return view('Admin.social.show',compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = Social::find($id);

        return view('Admin.social.edit',compact('post'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateSocialRequest $request, $id)
    {
        $social = Social::findOrFail($id);

        $social->update($request->requestHandler());

         return redirect()->route('socials.index')->with('message',
            show_success());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $social = Social::find($id);
        if($social->image){
          delete_file($social->image);
        }

          if($social->da_image){
          delete_file($social->da_image);
        }
          if($social->pa_image){
          delete_file($social->pa_image);
        }

        if($social->delete()){
            return redirect()->route('socials.index')->with('message',show_success());
        }
    }
}