<?php

namespace App\Http\Controllers\admin;

use App\Models\Page;
use App\Models\SubMenu;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Menu\StoreMenuRequest;
use App\Http\Requests\Menu\StoreSubMenuRequest;
use App\Http\Requests\Menu\UpdateSubMenuRequest;
use App\Models\Menu;
use Exception;

class SubMenuController extends Controller
{
    public function index()
    {


        $submenus = SubMenu::orderBy('sub_menu_order','ASC')->paginate(config('aictcms.pageNumber'));

        return view('Admin.submenu.index',compact('submenus'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($menu)
    {

        $submenus = SubMenu::get();

        $submenu = SubMenu::where('menu_id',$menu)->orderBy('sub_menu_order','desc')->first();

        if($submenu){
            $subMenuOrder = $submenu->sub_menu_order+1;
        }else{
            $subMenuOrder=1;
        }

        // $directories =  Storage::disk('admin')->directories();

        // Enum Pages route name
        $pages = sub_menus();
        return view('Admin.submenu.create',compact('pages','subMenuOrder','menu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreSubMenuRequest $request)
    {
           // find menu
           $menu = Menu::where('id',$request->menu_id)->first();

        if($request->image){
           $page =  Page::create($request->pageHandler());
           SubMenu::create($request->subMenuHandler($page->id));
         }else{

             SubMenu::create($request->subMenuHandler());
         }

           return redirect()->route('submenus.show',$menu->id)->with('message','The submenu has been successfully added!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($menuId)
    {
        $submenus = SubMenu::Where('menu_id',$menuId)->orderBy('sub_menu_order','ASC')->get();

        $menu = Menu::where('id',$menuId)->first();
        $menu_name = $menu->menu_name;

        return view('Admin.submenu.index',compact('submenus','menu'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(SubMenu $submenu)
    {
               // Enum Pages route name
               $pages = sub_menus();

        if($submenu->sub_resource_id){
        $post = Page::where('id',$submenu->sub_resource_id)->first();

        return view('Admin.submenu.edit',compact('submenu','post'));
        }

        return view('Admin.submenu.edit',compact('submenu','pages'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateSubMenuRequest $request, $id)
    {



           $submenu = SubMenu::findOrFail($id);
           $menu = Menu::findOrFail($submenu->menu_id);

           if($submenu->sub_resource_id){
            $page = Page::find($submenu->sub_resource_id);


             $page->update($request->pageHandler());
           }

           $submenu->update($request->menuHandler());

            return redirect()->route('submenus.show',$menu->id)->with('message',
            show_success());


    }


  // Eidt SubMenu order
  public function order(Request $request){
    foreach ($request->sub_menu_orders as $key => $value) {
        SubMenu::where('id',$key)->update([
            'sub_menu_order'=>$value
        ]);
    }

    return redirect()->back()->with('message',show_success());
  }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(SubMenu $submenu)
    {

        if($submenu->sub_resource_id){
            $page = Page::findOrfail($submenu->sub_resource_id);
            if($page->image){
               delete_file($page->image);
            }
            $page->delete();

        }

        if($submenu->delete()){
            return redirect()->route('submenus.show',$submenu->menu_id)->with('message','The sub menu has been successfully deleted!');
        }
    }

}