<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index(Request $request)
    {
        if($search = $request->search){
          $Users = User::where('name','LIKE',"%{$search}%")->paginate(config('aictcms.pageNumber'))->withQueryString();
        }else{
        $Users = User::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        }
        return view('Admin.users.index',compact('Users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.users.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


               $request->validate([
                'name' => ['required', 'string', 'max:255'],
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => ['required', 'string', 'min:8', 'confirmed'],
              ]);



            User::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
            ]);


           return redirect()->route('users.index')->with('message',show_success());

        }


      public function edit($id){

          if(auth()->user()->id!=$id){
            return redirect()->back();
          }
          $user = User::findOrFail($id);
        return view('Admin.users.edit',compact('user'));

      }

 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $user = User::findOrFail($id);
         $request->validate([

            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
          ]);


          $auth = Auth::user();

          // The passwords matches
                 if (!Hash::check($request->get('current_password'), $auth->password))
                 {
                     return back()->with('error', __("auth.password"));
                 }
        // upate
        $user->password=Hash::make( $request->input('password'));

        if($user->save()){
            return redirect()->route('dashboard.index')->with('message',
            show_success());
        }

    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {

        if($user->delete()){
            return redirect()->route('users.index')->with('message',show_success());
        }
    }


}
