<?php

namespace App\Http\Controllers\admin;

use App\Models\Video;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VideoController extends Controller
{
    public function index(Request $request)
    {

        $Videos = Video::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();

        return view('Admin.video.index',compact('Videos'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.Video.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


               $request->validate([
                'title'=>'required',
                'url'=>'required',
              ]);

           Video::create([
            'title'=>$request->title,
            'url'=>$request->url,
           ]);

           return redirect()->route('videos.index')->with('message',show_success());

    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Video $Video)
    {
        return view('Admin.video.show',compact('Video'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Video $video)
    {


        return view('Admin.video.edit',compact('video'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

           $Video = Video::findOrFail($id);

           $request->validate([
            'title'=>'required',
            'url'=>'required',
           ]);


        // upate
        $Video->title=$request->input('title');
        $Video->url=$request->input('url');

        if($Video->save()){
            return redirect()->route('videos.index')->with('message',
            show_success());
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
          $Video  = Video::findOrFail($id);
        if($Video->delete()){
            return redirect()->route('videos.index')->with('message',show_success());
        }
    }


}