<?php

namespace App\Http\Controllers\admin;

use App\Models\WhatWe;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;

class WhatController extends Controller
{
    public function index(Request $request)
    {
        if($search = $request->search){
          $WhatWes = WhatWe::where('title','LIKE',"%{$search}%")->paginate(config('aictcms.pageNumber'))->withQueryString();
        }else{
        $WhatWes = WhatWe::latest()->paginate(config('aictcms.pageNumber'))->withQueryString();
        }
        return view('Admin.what_we.index',compact('WhatWes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.what_we.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


               $request->validate([
                'title'=>'required',
                'description'=>'nullable',
                'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
              ]);


           // image store
           if($request->hasFile('image')){
             $imageName = time().'.'.$request->image->extension();
             $imagePath = $request->image->move('images/WhatWes',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);

           }else{
            $imagePath = null;
           }

           WhatWe::create([
            'title'=>$request->title,
            'description'=>$request->description,
            'image'=>$imagePath
           ]);

           return redirect()->route('news.index')->with('message',show_success());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(WhatWe $WhatWe)
    {
        return view('Admin.what_we.show',compact('WhatWe'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($whatwe)
    {

          $whatwe = Whatwe::find($whatwe);

        return view('Admin.what_we.edit',compact('whatwe'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

           $WhatWe = WhatWe::findOrFail($id);

           $request->validate([
            'title'=>'required',
            'description'=>'nullable',

            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
           ]);

          if($request->hasFile('image')){
            if($WhatWe->image){
                try{
                unlink($WhatWe['image']);
                }catch(Exception $e){
                    $message = $e->getMessage();
                }
            }


             $imageName = time().'.'.$request->image->extension();
             $imagePath = $request->image->move('images/WhatWes',$imageName);
             $imagePath = str_replace("\\", "/", $imagePath);
          }else{

           $imagePath = $WhatWe->image;
       }

        // upate
        $WhatWe->title=$request->input('title');
        $WhatWe->description = $request->input('description');
        $WhatWe->image = $imagePath;

        if($WhatWe->save()){
            return redirect()->route('news.index')->with('message',
            show_success());
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $WhatWe = WhatWe::findOrFail($id);
        if($WhatWe->image){

            try{

            unlink($WhatWe->image);
             $message = show_success();
            }catch(Exception $e){
                $message = $e->getMessage();

            }
        }

        if($WhatWe->delete()){
            return redirect()->route('news.index')->with('message',$message);
        }
    }


}