<?php

namespace App\Http\Controllers\website;

use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\ContactRequest;
use App\Mail\ContactMail;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index(){
        return view('website.contact.index');
    }

    public function sendMessage(ContactRequest $request){

        try {
            Mail::to(company()->email1)->send(new ContactMail($request->all()));

            toast('Your message has been sent successfully.','success');
            return redirect()->back();
        }catch(Exception $e){
            toast('Your message not sent','error');
            return redirect()->back();
        }
    }
}