<?php

namespace App\Http\Requests\About;

use Illuminate\Foundation\Http\FormRequest;

class StoreAboutCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'title'=>'required',
            'description'=>'required',
            'image'=>'required|image|mimes:png,jpg,jpeg,gif'
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();

      $allRequest['image'] = upload_file($this->image);
      return $allRequest;
    }
}