<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;

class StoreCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
     public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name'=>'required',
            'description'=>'required',
            'da_description'=>'required',
            'pa_description'=>'required',
            'logo'=>'required|image|mimes:png,jpg,jpeg,gif',
            'da_logo'=>'required|image|mimes:png,jpg,jpeg,gif',
            'fotoer_logo'=>'nullable|image|mimes:png,jpg,jpeg,gif',
            'da_footer_logo'=>'nullable|image|mimes:png,jpg,jpeg,gif'
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();

      $allRequest['logo'] = upload_file($this->logo);

      $allRequest['da_logo'] = upload_file($this->da_logo);
      $allRequest['da_footer_logo'] = upload_file($this->da_footer_logo);
      $allRequest['footer_logo'] = upload_file($this->footer_logo);

      return $allRequest;
    }

}