<?php

namespace App\Http\Requests\Media;

use Illuminate\Foundation\Http\FormRequest;

class StoreBannerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */


        public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'image'=>'required|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:9120 ',
            'da_image'=>'required|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:9120 ',
            'pa_image'=>'required|mimes:png,jpg,jpeg,gif,mp4,mov,ogg|max:9120 ',
        ];
    }

    public function requestHandler(){
      $allRequest = $this->all();
      if ($this->hasFile('image')) {
        $allRequest['image'] = upload_file($this->image);
      }
      if ($this->hasFile('da_image')) {
        $allRequest['da_image'] = upload_file($this->da_image);
      }
      if ($this->hasFile('pa_image')) {
          $allRequest['pa_image'] = upload_file($this->pa_image);
      }
      return $allRequest;
    }

}