<?php

namespace App\Http\Requests\Menu;

use Illuminate\Foundation\Http\FormRequest;

class StoreMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif',
            'menu_name'=>'required',
            'da_menu_name'=>'required',
            'pa_menu_name'=>'required',
            'route_name'=>'required',
        ];
    }




    public function pageHandler(){
             $allRequest = $this->all();
             if($this->hasFile('image')){
                 $allRequest['image'] = upload_file($this->image);
             }else{
                 $allRequest['image'] = null;
             }
           return $allRequest;
     }

   public function menuHandler($pageId=null){
       $allRequest = $this->all();
       $allRequest['resource_id'] = $pageId;
       return $allRequest;
    }

      public function subMenuHandler($pageId=null){
       $allRequest = $this->all();
       $allRequest['sub_resource_id'] = $pageId;
       return $allRequest;
    }

}
