<?php

namespace App\Http\Requests\Post;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

        public function authorize()
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'title'=>'required',
            'description'=>'required',
            'image'=>'nullable|image|mimes:png,jpg,jpeg,gif'
        ];
    }

      public function requestHandler(){
      $allRequest = $this->all();
      if($this->image){
      $allRequest['image'] = upload_file($this->image);
       delete_file($this->old_image);
      }else{
      $allRequest['image'] = $this->old_image;
      }

      return $allRequest;
    }
}