<?php
namespace App\Http\Service;

use App\Models\Image;

trait ImageService {
    public function storeImage($file,$name){

        if($file){
            $imageName = str()->random(6).time().'.'.$file->extension();

            $imagePath = $file->move('images/'.$name.'/',$imageName);
            $imagePath = str_replace("\\", "/", $imagePath);


          }else{
           $imagePath = null;
          }
          return $imagePath;
    }
    public function storeMultipleImages($images,$type,$id){


        foreach ($images as $image ){

         $imagePath = $this->storeImage($image,'images');
         $new_image = Image::create([
            'url' => $imagePath,
            'imageable_id' => $id,
            'imageable_type' => $type
         ]);
        }
    }


    public function limitWords($word){
        return str()->words($word,10);
    }
}